<?php

declare(strict_types=1);

namespace Erlage\Photogram\Requests\Collection;

use Erlage\Photogram\Settings;
use Erlage\Photogram\Data\Query;
use Erlage\Photogram\Helpers\TraitFeedHelper;
use Erlage\Photogram\Constants\ServerConstants;
use Erlage\Photogram\Constants\ResponseConstants;
use Erlage\Photogram\Pattern\ExceptionalRequests;
use Erlage\Photogram\Data\Tables\Collection\CollectionTable;

final class CollectionContent extends ExceptionalRequests
{
    use TraitFeedHelper;

    public static function load(string $loadingType): void
    {
        self::feedHelperInit('', $loadingType);

        self::process(function ()
        {
            /*
            |--------------------------------------------------------------------------
            | get data from request
            |--------------------------------------------------------------------------
            */

            $offset = self::$request -> findKeyOffset(CollectionTable::ID, CollectionTable::TABLE_NAME);

            /*
            |--------------------------------------------------------------------------
            | make sure user is authenticated
            |--------------------------------------------------------------------------
            */

            self::userEnsureAuthenticated();

            /*
            |--------------------------------------------------------------------------
            | query builder
            |--------------------------------------------------------------------------
            */

            $collectionTableQuery = (new Query()) -> from(CollectionTable::TABLE_NAME);

            /*
            |--------------------------------------------------------------------------
            | that are from current user
            |--------------------------------------------------------------------------
            */

            $collectionTableQuery -> where(CollectionTable::OWNER_USER_ID, self::$authedUserModel -> getId());

            /*
            |--------------------------------------------------------------------------
            | selection order
            |--------------------------------------------------------------------------
            */

            if (self::isLoadingLatestContent())
            {
                $collectionTableQuery -> greaterThan(CollectionTable::ID, $offset);
            }
            else
            {
                $collectionTableQuery -> lessThan(CollectionTable::ID, $offset);
            }

            /*
            |--------------------------------------------------------------------------
            | order by & limit
            |--------------------------------------------------------------------------
            */

            $collectionTableQuery
                -> orderByDesc(CollectionTable::ID)
                -> limit(Settings::getString(ServerConstants::SS_INT_LIMIT_LOAD_COLLECTION));

            /*
            |--------------------------------------------------------------------------
            | get beans
            |--------------------------------------------------------------------------
            */

            $collectionBeans = $collectionTableQuery -> select();

            /*
            |--------------------------------------------------------------------------
            | check end of results
            |--------------------------------------------------------------------------
            */

            if (0 == \count($collectionBeans))
            {
                return self::setMessage(ResponseConstants::END_OF_RESULTS_MSG);
            }

            /*
            |--------------------------------------------------------------------------
            | else add to response
            |--------------------------------------------------------------------------
            */

            self::processBeans(CollectionTable::getTableName(), $collectionBeans);
        });
    }
}
